# Promitto - Property Management Website

A modern, responsive property management website built with Next.js, TypeScript, and Tailwind CSS.

## Features

- Clean, minimalist design
- Responsive layout for all devices
- Property search with filters
- Featured properties showcase
- Why Choose Us section
- Contact information
- Social media integration

## Tech Stack

- Next.js 14
- TypeScript
- Tailwind CSS
- React 18

## Getting Started

### Prerequisites

- Node.js 18.17 or later
- npm or yarn

### Installation

1. Clone the repository:
```bash
git clone https://github.com/yourusername/promitto.git
cd promitto
```

2. Install dependencies:
```bash
npm install
# or
yarn install
```

3. Run the development server:
```bash
npm run dev
# or
yarn dev
```

4. Open [http://localhost:3000](http://localhost:3000) with your browser to see the result.

## Project Structure

```
promitto/
├── src/
│   ├── app/
│   │   ├── layout.tsx
│   │   ├── page.tsx
│   │   └── globals.css
│   └── components/
│       ├── Header.tsx
│       ├── Hero.tsx
│       ├── FeaturedProperties.tsx
│       ├── PropertyCard.tsx
│       ├── WhyChooseUs.tsx
│       └── Footer.tsx
├── public/
├── tailwind.config.js
├── postcss.config.js
├── package.json
└── README.md
```

## Contributing

1. Fork the repository
2. Create your feature branch (`git checkout -b feature/amazing-feature`)
3. Commit your changes (`git commit -m 'Add some amazing feature'`)
4. Push to the branch (`git push origin feature/amazing-feature`)
5. Open a Pull Request

## License

This project is licensed under the MIT License - see the LICENSE file for details. 